

library(data.table)
library(magrittr)


data <- read.csv('data_for_macropru_analysis.csv')

# Break up LVR categories into more useful values
data2 <- data %>% data.table %>%
  .[, inv_lvrto80 := Appr_Inv_Tot - Appr_Inv_LVRabove80 - Appr_Inv_LVRabove90] %>%
  .[, inv_lvr80to90 := Appr_Inv_LVRabove80] %>%
  .[, inv_lvr90up := Appr_Inv_LVRabove90] %>%
  .[, occ_lvrto80 := Appr_Occ_Tot - Appr_Occ_LVRabove80 - Appr_Occ_LVRabove90] %>%
  .[, occ_lvr80to90 := Appr_Occ_LVRabove80] %>%
  .[, occ_lvr90up := Appr_Occ_LVRabove90]



lvr_data <- data2 %>% 
  melt(id.vars=c('period', 'bank', 'GDP_qpd', 'housepr_qpd', 
                 'Tier1Cap', 'TotalRWA', 'Deposits', 'Liabilities'),
       measure.vars=c('inv_lvrto80', 'inv_lvr80to90', 'inv_lvr90up', 'Appr_Inv_Tot',
                      'occ_lvrto80', 'occ_lvr80to90', 'occ_lvr90up', 'Appr_Occ_Tot'),
       variable.name='type', value.name='approvals') %>%
  setorder(bank, type, period) %>%
  .[, appr_gr := c(NA, tail(approvals, -1)/head(approvals, -1) - 1), 
    by=c('bank', 'type')] %>%
  .[, lcapitalratio := c(NA, head(Tier1Cap/TotalRWA, -1)), by=c('bank', 'type')] %>%
  .[, lfunding := c(NA, head(Deposits/Liabilities, -1)),by=c('bank', 'type')] %>%
  .[, appr_gr_l1 := c(NA, head(appr_gr, -1)), by=c('bank', 'type')] %>%
  .[, appr_gr_l2 := c(NA, NA, head(appr_gr, -2)), by=c('bank', 'type')] %>%
  .[, appr_gr_l3 := c(NA, NA, NA, head(appr_gr, -3)), by=c('bank', 'type')]

write.csv(lvr_data, 'lvr_data_for_analysis.csv', row.names=FALSE)


